/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jpcsp.Emulator;
import jpcsp.GUI.CancelButton;
import jpcsp.MainGUI;
import jpcsp.WindowPropSaver;
import jpcsp.log.LogWindow;
import jpcsp.settings.Settings;
import jpcsp.util.Constants;

public class LogGUI
extends JFrame {
    private static final long serialVersionUID = -732715495873159718L;
    private static final String LB = System.getProperty("line.separator");
    private MainGUI mainWindow = null;
    private String LogSettingsPath;
    private JPanel LoggerAdvancedPanel;
    private JPanel LoggerGeneralPanel;
    private JPanel LoggerSettingsPanel;
    private JCheckBox atracBox;
    private JCheckBox audioBox;
    private ButtonGroup buttonGroup1;
    private JCheckBox compilerBox;
    private JCheckBox cpuBox;
    private JCheckBox ctrlBox;
    private JCheckBox defltBox;
    private JCheckBox displayBox;
    private JCheckBox dmacBox;
    private JCheckBox emuBox;
    private JButton fileButton;
    private JCheckBox fontBox;
    private JCheckBox geUserBox;
    private JCheckBox gpuBox;
    private JCheckBox hprmBox;
    private JCheckBox imposeBox;
    private JCheckBox interruptMgrBox;
    private JCheckBox ioFileMgrBox;
    private CancelButton jButtonCancel;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JCheckBox kernelLibBox;
    private JLabel lblCustom;
    private JLabel lblLogMethod;
    private JLabel lblMaxFileSize;
    private JLabel lblOutputFile;
    private JLabel lblSettingsPath;
    private JCheckBox loadCoreBox;
    private JCheckBox loadExecBox;
    private JCheckBox loaderBox;
    private JCheckBox logByKeywordCheck;
    private JTextField logKeywordField;
    private JTextField logoutpath;
    private JSpinner maxSizeSpinner;
    private JCheckBox memBox;
    private JCheckBox moduleMgrBox;
    private JCheckBox mp3Box;
    private JCheckBox mpegBox;
    private JCheckBox openLogWindowCheck;
    private JCheckBox outputToHTML;
    private JCheckBox outputToText;
    private JCheckBox powerBox;
    private JCheckBox psmfBox;
    private JCheckBox psmfPlayerBox;
    private JRadioButton rbCPUDebug;
    private JRadioButton rbCoreDebug;
    private JRadioButton rbCustom;
    private JRadioButton rbFullDebug;
    private JRadioButton rbGPUDebug;
    private JRadioButton rbGeneralDebug;
    private JCheckBox rtcBox;
    private JCheckBox runtimeBox;
    private JCheckBox sasBox;
    private JButton saveButton;
    private JTextArea settingsArea;
    private JCheckBox snapConsoleCheck;
    private JCheckBox splitFilesBox;
    private JCheckBox stderrBox;
    private JCheckBox stdioBox;
    private JCheckBox stdoutBox;
    private JCheckBox suspendBox;
    private JCheckBox sysMemKernelBox;
    private JCheckBox sysMemUserBox;
    private JCheckBox threadManBox;
    private JCheckBox umdBox;
    private JCheckBox utilityBox;
    private JCheckBox utilsBox;
    private JTextField xmlpath;

    public LogGUI(MainGUI main) {
        this.mainWindow = main;
        this.setLocationRelativeTo(main);
        this.initComponents();
        this.setLogSettingsFile();
        this.RefreshWindow();
        WindowPropSaver.loadWindowProperties(this);
    }

    public void setMainGUI(MainGUI mainWindow) {
        this.mainWindow = mainWindow;
    }

    private void setLogSettingsFile() {
        this.LogSettingsPath = this.xmlpath.getText();
        LogWindow.setConfXMLFile(this.LogSettingsPath);
        this.printLogSettingsFile();
    }

    private void printLogSettingsFile() {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.LogSettingsPath, "r");
            while (raf.getFilePointer() < raf.length()) {
                this.settingsArea.append(raf.readLine() + LB);
            }
            raf.close();
        }
        catch (Exception e) {
            this.settingsArea.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.LoggerGeneralPanel = new JPanel();
        this.openLogWindowCheck = new JCheckBox();
        this.snapConsoleCheck = new JCheckBox();
        this.logKeywordField = new JTextField();
        this.logByKeywordCheck = new JCheckBox();
        this.LoggerSettingsPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.settingsArea = new JTextArea();
        this.fileButton = new JButton();
        this.xmlpath = new JTextField();
        this.lblSettingsPath = new JLabel();
        this.outputToHTML = new JCheckBox();
        this.outputToText = new JCheckBox();
        this.lblOutputFile = new JLabel();
        this.logoutpath = new JTextField();
        this.lblMaxFileSize = new JLabel();
        this.maxSizeSpinner = new JSpinner();
        this.splitFilesBox = new JCheckBox();
        this.LoggerAdvancedPanel = new JPanel();
        this.rbGeneralDebug = new JRadioButton();
        this.rbCPUDebug = new JRadioButton();
        this.rbGPUDebug = new JRadioButton();
        this.rbCoreDebug = new JRadioButton();
        this.rbFullDebug = new JRadioButton();
        this.rbCustom = new JRadioButton();
        this.lblLogMethod = new JLabel();
        this.interruptMgrBox = new JCheckBox();
        this.ioFileMgrBox = new JCheckBox();
        this.kernelLibBox = new JCheckBox();
        this.loadCoreBox = new JCheckBox();
        this.loadExecBox = new JCheckBox();
        this.moduleMgrBox = new JCheckBox();
        this.stdioBox = new JCheckBox();
        this.sysMemKernelBox = new JCheckBox();
        this.sysMemUserBox = new JCheckBox();
        this.threadManBox = new JCheckBox();
        this.utilsBox = new JCheckBox();
        this.atracBox = new JCheckBox();
        this.audioBox = new JCheckBox();
        this.ctrlBox = new JCheckBox();
        this.defltBox = new JCheckBox();
        this.displayBox = new JCheckBox();
        this.dmacBox = new JCheckBox();
        this.fontBox = new JCheckBox();
        this.geUserBox = new JCheckBox();
        this.hprmBox = new JCheckBox();
        this.imposeBox = new JCheckBox();
        this.mp3Box = new JCheckBox();
        this.mpegBox = new JCheckBox();
        this.powerBox = new JCheckBox();
        this.psmfBox = new JCheckBox();
        this.psmfPlayerBox = new JCheckBox();
        this.rtcBox = new JCheckBox();
        this.sasBox = new JCheckBox();
        this.suspendBox = new JCheckBox();
        this.umdBox = new JCheckBox();
        this.utilityBox = new JCheckBox();
        this.cpuBox = new JCheckBox();
        this.gpuBox = new JCheckBox();
        this.compilerBox = new JCheckBox();
        this.memBox = new JCheckBox();
        this.emuBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.lblCustom = new JLabel();
        this.loaderBox = new JCheckBox();
        this.runtimeBox = new JCheckBox();
        this.stdoutBox = new JCheckBox();
        this.stderrBox = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.saveButton = new JButton();
        this.jButtonCancel = new CancelButton();
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("LogGUI.title"));
        this.setResizable(false);
        this.jButtonOK.setText(bundle.getString("OkButton.text"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.openLogWindowCheck.setText(bundle.getString("LogGUI.openLogWindowCheck.text"));
        this.snapConsoleCheck.setText(bundle.getString("LogGUI.snapConsoleCheck.text"));
        this.logKeywordField.setEditable(false);
        this.logKeywordField.setText("LOG_ALL");
        this.logByKeywordCheck.setText(bundle.getString("LogGUI.logByKeywordCheck.text"));
        this.logByKeywordCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.logByKeywordCheckActionPerformed(evt);
            }
        });
        GroupLayout LoggerGeneralPanelLayout = new GroupLayout(this.LoggerGeneralPanel);
        this.LoggerGeneralPanel.setLayout(LoggerGeneralPanelLayout);
        LoggerGeneralPanelLayout.setHorizontalGroup(LoggerGeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerGeneralPanelLayout.createSequentialGroup().addContainerGap().addGroup(LoggerGeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerGeneralPanelLayout.createSequentialGroup().addComponent(this.logByKeywordCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logKeywordField, -2, 200, -2).addGap(0, 306, Short.MAX_VALUE)).addComponent(this.openLogWindowCheck, -1, -1, Short.MAX_VALUE).addComponent(this.snapConsoleCheck, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        LoggerGeneralPanelLayout.setVerticalGroup(LoggerGeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerGeneralPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.openLogWindowCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.snapConsoleCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerGeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.logByKeywordCheck).addComponent(this.logKeywordField, -2, -1, -2)).addContainerGap(248, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("LogGUI.LoggerGeneralPanel.TabConstraints.tabTitle"), this.LoggerGeneralPanel);
        this.settingsArea.setEditable(false);
        this.settingsArea.setColumns(20);
        this.settingsArea.setRows(5);
        this.jScrollPane1.setViewportView(this.settingsArea);
        this.fileButton.setText("...");
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.fileButtonActionPerformed(evt);
            }
        });
        this.xmlpath.setEditable(false);
        this.xmlpath.setText("LogSettings.xml");
        this.lblSettingsPath.setText(bundle.getString("LogGUI.lblSettingsPath.text"));
        this.outputToHTML.setSelected(true);
        this.outputToHTML.setText(bundle.getString("LogGUI.outputToHTML.text"));
        this.outputToText.setText(bundle.getString("LogGUI.outputToText.text"));
        this.lblOutputFile.setText(bundle.getString("LogGUI.lblOutputFile.text"));
        this.logoutpath.setText("log");
        this.lblMaxFileSize.setText(bundle.getString("LogGUI.lblMaxFileSize.text"));
        this.maxSizeSpinner.setModel(new SpinnerNumberModel(0, 0, 100000, 1));
        this.maxSizeSpinner.setEnabled(this.splitFilesBox.isSelected());
        this.splitFilesBox.setText(bundle.getString("LogGUI.splitFilesBox.text"));
        this.splitFilesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.splitFilesBoxActionPerformed(evt);
            }
        });
        GroupLayout LoggerSettingsPanelLayout = new GroupLayout(this.LoggerSettingsPanel);
        this.LoggerSettingsPanel.setLayout(LoggerSettingsPanelLayout);
        LoggerSettingsPanelLayout.setHorizontalGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 418, -2).addGap(18, 18, 18).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputToText, -1, 369, Short.MAX_VALUE).addComponent(this.outputToHTML, -1, 369, Short.MAX_VALUE).addGroup(LoggerSettingsPanelLayout.createSequentialGroup().addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblOutputFile).addComponent(this.lblMaxFileSize).addComponent(this.lblSettingsPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerSettingsPanelLayout.createSequentialGroup().addComponent(this.xmlpath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileButton, -2, 23, -2)).addGroup(LoggerSettingsPanelLayout.createSequentialGroup().addComponent(this.maxSizeSpinner).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitFilesBox)).addComponent(this.logoutpath)))).addContainerGap()));
        LoggerSettingsPanelLayout.setVerticalGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, LoggerSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, LoggerSettingsPanelLayout.createSequentialGroup().addComponent(this.outputToHTML).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputToText).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOutputFile).addComponent(this.logoutpath, -2, -1, -2)).addGap(18, 18, 18).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMaxFileSize).addComponent(this.splitFilesBox).addComponent(this.maxSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 162, Short.MAX_VALUE).addGroup(LoggerSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSettingsPath).addComponent(this.xmlpath, -2, -1, -2).addComponent(this.fileButton))).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING)).addContainerGap()));
        this.jTabbedPane1.addTab(bundle.getString("LogGUI.LoggerSettingsPanel.TabConstraints.tabTitle"), this.LoggerSettingsPanel);
        this.LoggerAdvancedPanel.setEnabled(this.rbCustom.isSelected());
        this.buttonGroup1.add(this.rbGeneralDebug);
        this.rbGeneralDebug.setSelected(true);
        this.rbGeneralDebug.setText(bundle.getString("LogGUI.rbGeneralDebug.text"));
        this.rbGeneralDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.rbGeneralDebugActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbCPUDebug);
        this.rbCPUDebug.setText(bundle.getString("LogGUI.rbCPUDebug.text"));
        this.rbCPUDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.rbCPUDebugActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbGPUDebug);
        this.rbGPUDebug.setText(bundle.getString("LogGUI.rbGPUDebug.text"));
        this.rbGPUDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.rbGPUDebugActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbCoreDebug);
        this.rbCoreDebug.setText(bundle.getString("LogGUI.rbCoreDebug.text"));
        this.rbCoreDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.rbCoreDebugActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbFullDebug);
        this.rbFullDebug.setText(bundle.getString("LogGUI.rbFullDebug.text"));
        this.rbFullDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.rbFullDebugActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbCustom);
        this.rbCustom.setText(bundle.getString("LogGUI.rbCustom.text"));
        this.rbCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.rbCustomActionPerformed(evt);
            }
        });
        this.lblLogMethod.setText(bundle.getString("LogGUI.lblLogMethod.text"));
        this.interruptMgrBox.setText("InterruptManager");
        this.interruptMgrBox.setEnabled(this.rbCustom.isSelected());
        this.ioFileMgrBox.setText("IoFileMgrForUser");
        this.ioFileMgrBox.setEnabled(this.rbCustom.isSelected());
        this.kernelLibBox.setText("Kernel_Library");
        this.kernelLibBox.setEnabled(this.rbCustom.isSelected());
        this.loadCoreBox.setText("LoadCoreForKernel");
        this.loadCoreBox.setEnabled(this.rbCustom.isSelected());
        this.loadExecBox.setText("LoadExecForUser");
        this.loadExecBox.setEnabled(this.rbCustom.isSelected());
        this.moduleMgrBox.setText("ModuleMgrForUser");
        this.moduleMgrBox.setEnabled(this.rbCustom.isSelected());
        this.stdioBox.setText("StdioForUser");
        this.stdioBox.setEnabled(this.rbCustom.isSelected());
        this.sysMemKernelBox.setText("SysMemForKernel");
        this.sysMemKernelBox.setEnabled(this.rbCustom.isSelected());
        this.sysMemUserBox.setText("SysMemUserForUser");
        this.sysMemUserBox.setEnabled(this.rbCustom.isSelected());
        this.threadManBox.setText("ThreadManForUser");
        this.threadManBox.setEnabled(this.rbCustom.isSelected());
        this.utilsBox.setText("UtilsForUser");
        this.utilsBox.setEnabled(this.rbCustom.isSelected());
        this.atracBox.setText("sceAtrac3plus");
        this.atracBox.setEnabled(this.rbCustom.isSelected());
        this.audioBox.setText("sceAudio");
        this.audioBox.setEnabled(this.rbCustom.isSelected());
        this.ctrlBox.setText("sceCtrl");
        this.ctrlBox.setEnabled(this.rbCustom.isSelected());
        this.defltBox.setText("sceDeflt");
        this.defltBox.setEnabled(this.rbCustom.isSelected());
        this.displayBox.setText("sceDisplay");
        this.displayBox.setEnabled(this.rbCustom.isSelected());
        this.dmacBox.setText("sceDmac");
        this.dmacBox.setEnabled(this.rbCustom.isSelected());
        this.fontBox.setText("sceFont");
        this.fontBox.setEnabled(this.rbCustom.isSelected());
        this.geUserBox.setText("sceGe_user");
        this.geUserBox.setEnabled(this.rbCustom.isSelected());
        this.hprmBox.setText("sceHprm");
        this.hprmBox.setEnabled(this.rbCustom.isSelected());
        this.imposeBox.setText("sceImpose");
        this.imposeBox.setEnabled(this.rbCustom.isSelected());
        this.mp3Box.setText("sceMp3");
        this.mp3Box.setEnabled(this.rbCustom.isSelected());
        this.mpegBox.setText("sceMpeg");
        this.mpegBox.setEnabled(this.rbCustom.isSelected());
        this.powerBox.setText("scePower");
        this.powerBox.setEnabled(this.rbCustom.isSelected());
        this.psmfBox.setText("scePsmf");
        this.psmfBox.setEnabled(this.rbCustom.isSelected());
        this.psmfPlayerBox.setText("scePsmfPlayer");
        this.psmfPlayerBox.setEnabled(this.rbCustom.isSelected());
        this.rtcBox.setText("sceRtc");
        this.rtcBox.setEnabled(this.rbCustom.isSelected());
        this.sasBox.setText("sceSasCore");
        this.sasBox.setEnabled(this.rbCustom.isSelected());
        this.suspendBox.setText("sceSuspendForUser");
        this.suspendBox.setEnabled(this.rbCustom.isSelected());
        this.umdBox.setText("sceUmdUser");
        this.umdBox.setEnabled(this.rbCustom.isSelected());
        this.utilityBox.setText("sceUtility");
        this.utilityBox.setEnabled(this.rbCustom.isSelected());
        this.cpuBox.setText("CPU");
        this.cpuBox.setEnabled(this.rbCustom.isSelected());
        this.gpuBox.setText("GPU");
        this.gpuBox.setEnabled(this.rbCustom.isSelected());
        this.compilerBox.setText("Compiler");
        this.compilerBox.setEnabled(this.rbCustom.isSelected());
        this.memBox.setText("Memory");
        this.memBox.setEnabled(this.rbCustom.isSelected());
        this.emuBox.setText("Emulator");
        this.emuBox.setEnabled(this.rbCustom.isSelected());
        this.lblCustom.setText(bundle.getString("LogGUI.lblCustom.text"));
        this.loaderBox.setText("Loader");
        this.loaderBox.setEnabled(this.rbCustom.isSelected());
        this.runtimeBox.setText("Runtime");
        this.runtimeBox.setEnabled(this.rbCustom.isSelected());
        this.stdoutBox.setText("STDOUT");
        this.stdoutBox.setEnabled(this.rbCustom.isSelected());
        this.stderrBox.setText("STDERR");
        this.stderrBox.setEnabled(this.rbCustom.isSelected());
        GroupLayout LoggerAdvancedPanelLayout = new GroupLayout(this.LoggerAdvancedPanel);
        this.LoggerAdvancedPanel.setLayout(LoggerAdvancedPanelLayout);
        LoggerAdvancedPanelLayout.setHorizontalGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, LoggerAdvancedPanelLayout.createSequentialGroup().addContainerGap().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbCoreDebug, -1, -1, Short.MAX_VALUE).addComponent(this.rbFullDebug, -1, -1, Short.MAX_VALUE).addComponent(this.rbCustom, -1, -1, Short.MAX_VALUE).addComponent(this.rbGPUDebug, -1, -1, Short.MAX_VALUE).addComponent(this.lblLogMethod, -1, -1, Short.MAX_VALUE).addComponent(this.rbCPUDebug, -1, -1, Short.MAX_VALUE).addComponent(this.rbGeneralDebug, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addComponent(this.stdoutBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stderrBox)).addComponent(this.jSeparator2).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadExecBox, -1, -1, Short.MAX_VALUE).addComponent(this.sysMemKernelBox, -1, -1, Short.MAX_VALUE).addComponent(this.dmacBox, -1, -1, Short.MAX_VALUE).addComponent(this.audioBox, -1, -1, Short.MAX_VALUE).addComponent(this.imposeBox, -1, -1, Short.MAX_VALUE).addComponent(this.psmfBox, -1, -1, Short.MAX_VALUE).addComponent(this.suspendBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addComponent(this.interruptMgrBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ioFileMgrBox, -1, -1, Short.MAX_VALUE).addComponent(this.moduleMgrBox, -1, -1, Short.MAX_VALUE).addComponent(this.sysMemUserBox, -1, -1, Short.MAX_VALUE).addComponent(this.ctrlBox, -1, -1, Short.MAX_VALUE).addComponent(this.fontBox, -1, -1, Short.MAX_VALUE).addComponent(this.mp3Box, -1, -1, Short.MAX_VALUE).addComponent(this.psmfPlayerBox, -1, -1, Short.MAX_VALUE).addComponent(this.umdBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.geUserBox, -1, -1, Short.MAX_VALUE).addComponent(this.defltBox, -1, -1, Short.MAX_VALUE).addComponent(this.threadManBox, -1, -1, Short.MAX_VALUE).addComponent(this.kernelLibBox, -1, -1, Short.MAX_VALUE).addComponent(this.utilsBox, -1, -1, Short.MAX_VALUE).addComponent(this.mpegBox, -1, -1, Short.MAX_VALUE).addComponent(this.rtcBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sasBox, -1, -1, Short.MAX_VALUE).addComponent(this.powerBox, -1, -1, Short.MAX_VALUE).addComponent(this.hprmBox, -1, -1, Short.MAX_VALUE).addComponent(this.displayBox, -1, -1, Short.MAX_VALUE).addComponent(this.atracBox, -1, -1, Short.MAX_VALUE).addComponent(this.loadCoreBox, -1, -1, Short.MAX_VALUE).addComponent(this.stdioBox, -1, -1, Short.MAX_VALUE))).addComponent(this.utilityBox, -1, -1, Short.MAX_VALUE))).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addComponent(this.cpuBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.gpuBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.loaderBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.runtimeBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.compilerBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.memBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.emuBox, -1, -1, Short.MAX_VALUE)).addComponent(this.lblCustom, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        LoggerAdvancedPanelLayout.setVerticalGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addContainerGap().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCustom).addComponent(this.lblLogMethod, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cpuBox).addComponent(this.emuBox).addComponent(this.memBox).addComponent(this.compilerBox).addComponent(this.runtimeBox).addComponent(this.loaderBox).addComponent(this.gpuBox)).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.kernelLibBox).addComponent(this.loadCoreBox))).addGroup(GroupLayout.Alignment.TRAILING, LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.interruptMgrBox).addComponent(this.ioFileMgrBox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moduleMgrBox).addComponent(this.threadManBox).addComponent(this.stdioBox).addComponent(this.loadExecBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sysMemUserBox).addComponent(this.utilsBox).addComponent(this.atracBox).addComponent(this.sysMemKernelBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayBox).addComponent(this.ctrlBox).addComponent(this.defltBox).addComponent(this.audioBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontBox).addComponent(this.geUserBox).addComponent(this.hprmBox).addComponent(this.dmacBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.imposeBox).addComponent(this.mp3Box).addComponent(this.mpegBox).addComponent(this.powerBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmfBox).addComponent(this.psmfPlayerBox).addComponent(this.rtcBox).addComponent(this.sasBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.suspendBox).addComponent(this.umdBox)).addComponent(this.utilityBox))).addGroup(LoggerAdvancedPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.rbGeneralDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbCPUDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbGPUDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbCoreDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbFullDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbCustom))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LoggerAdvancedPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stdoutBox).addComponent(this.stderrBox)).addContainerGap(36, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(bundle.getString("LogGUI.LoggerAdvancedPanel.TabConstraints.tabTitle"), this.LoggerAdvancedPanel);
        this.saveButton.setText(bundle.getString("LogGUI.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogGUI.this.saveButtonActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText(bundle.getString("CancelButton.text"));
        this.jButtonCancel.setParent(this);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(layout.createSequentialGroup().addComponent(this.saveButton, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.saveButton).addComponent(this.jButtonCancel, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    public final void RefreshWindow() {
        this.openLogWindowCheck.setSelected(Settings.getInstance().readBool("gui.openLogwindow"));
        this.snapConsoleCheck.setSelected(Settings.getInstance().readBool("gui.snapLogwindow"));
        String keyword = Settings.getInstance().readString("log.keyword");
        if (!keyword.equals("LOG_ALL")) {
            this.logKeywordField.setText(keyword);
            this.logByKeywordCheck.setSelected(true);
        } else {
            this.logKeywordField.setText("LOG_ALL");
            this.logByKeywordCheck.setSelected(false);
        }
    }

    private void setCustom(boolean useCustom) {
        this.interruptMgrBox.setEnabled(useCustom);
        this.ioFileMgrBox.setEnabled(useCustom);
        this.kernelLibBox.setEnabled(useCustom);
        this.loadCoreBox.setEnabled(useCustom);
        this.loadExecBox.setEnabled(useCustom);
        this.moduleMgrBox.setEnabled(useCustom);
        this.stdioBox.setEnabled(useCustom);
        this.sysMemKernelBox.setEnabled(useCustom);
        this.sysMemUserBox.setEnabled(useCustom);
        this.threadManBox.setEnabled(useCustom);
        this.utilsBox.setEnabled(useCustom);
        this.atracBox.setEnabled(useCustom);
        this.audioBox.setEnabled(useCustom);
        this.ctrlBox.setEnabled(useCustom);
        this.defltBox.setEnabled(useCustom);
        this.displayBox.setEnabled(useCustom);
        this.dmacBox.setEnabled(useCustom);
        this.fontBox.setEnabled(useCustom);
        this.geUserBox.setEnabled(useCustom);
        this.hprmBox.setEnabled(useCustom);
        this.imposeBox.setEnabled(useCustom);
        this.mp3Box.setEnabled(useCustom);
        this.mpegBox.setEnabled(useCustom);
        this.powerBox.setEnabled(useCustom);
        this.psmfBox.setEnabled(useCustom);
        this.psmfPlayerBox.setEnabled(useCustom);
        this.rtcBox.setEnabled(useCustom);
        this.sasBox.setEnabled(useCustom);
        this.suspendBox.setEnabled(useCustom);
        this.umdBox.setEnabled(useCustom);
        this.utilityBox.setEnabled(useCustom);
        this.cpuBox.setEnabled(useCustom);
        this.gpuBox.setEnabled(useCustom);
        this.compilerBox.setEnabled(useCustom);
        this.memBox.setEnabled(useCustom);
        this.emuBox.setEnabled(useCustom);
        this.loaderBox.setEnabled(useCustom);
        this.runtimeBox.setEnabled(useCustom);
        this.stdoutBox.setEnabled(useCustom);
        this.stderrBox.setEnabled(useCustom);
    }

    private String selectLoggers() {
        String loggers = "";
        if (this.rbGeneralDebug.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' />" + LB + "<logger name='hle' />" + LB + "<logger name='memory' />" + LB + "<logger name='ge' />" + LB + "<logger name='emu' />" + LB + "<logger name='compiler' > <level value='off' /> </logger>" + LB + "<logger name='runtime' > <level value='off' /> </logger>" + LB + "<logger name='loader' > <level value='off' /> </logger>" + LB + "<logger name='stdout' />" + LB + "<logger name='stderr' />" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.rbCPUDebug.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' />" + LB + "<logger name='hle' > <level value='off' /> </logger>" + LB + "<logger name='memory' > <level value='off' /> </logger>" + LB + "<logger name='ge' > <level value='off' /> </logger>" + LB + "<logger name='emu' > <level value='off' /> </logger>" + LB + "<logger name='compiler' />" + LB + "<logger name='runtime' > <level value='off' /> </logger>" + LB + "<logger name='loader' > <level value='off' /> </logger>" + LB + "<logger name='stdout' />" + LB + "<logger name='stderr' />" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.rbGPUDebug.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' > <level value='off' /> </logger>" + LB + "<logger name='hle' > <level value='off' /> </logger>" + LB + "<logger name='memory' > <level value='off' /> </logger>" + LB + "<logger name='ge' />" + LB + "<logger name='emu' > <level value='off' /> </logger>" + LB + "<logger name='compiler' > <level value='off' /> </logger>" + LB + "<logger name='runtime' > <level value='off' /> </logger>" + LB + "<logger name='loader' > <level value='off' /> </logger>" + LB + "<logger name='stdout' />" + LB + "<logger name='stderr' />" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.rbCoreDebug.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' > <level value='off' /> </logger>" + LB + "<logger name='hle' > <level value='off' /> </logger>" + LB + "<logger name='memory' > <level value='off' /> </logger>" + LB + "<logger name='ge' > <level value='off' /> </logger>" + LB + "<logger name='emu' />" + LB + "<logger name='compiler' />" + LB + "<logger name='runtime' />" + LB + "<logger name='loader' />" + LB + "<logger name='stdout' > <level value='off' /> </logger>" + LB + "<logger name='stderr' > <level value='off' /> </logger>" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.rbFullDebug.isSelected()) {
            loggers = loggers + LB + "<logger name='cpu' />" + LB + "<logger name='hle' />" + LB + "<logger name='memory' />" + LB + "<logger name='ge' />" + LB + "<logger name='emu' />" + LB + "<logger name='compiler' />" + LB + "<logger name='runtime' />" + LB + "<logger name='loader' />" + LB + "<logger name='stdout' />" + LB + "<logger name='stderr' />" + LB + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        } else if (this.rbCustom.isSelected()) {
            loggers = this.interruptMgrBox.isSelected() ? loggers + LB + "<logger name='hle.InterruptManager' />" + LB : loggers + LB + "<logger name='hle.InterruptManager' > <level value='off' /> </logger>" + LB;
            loggers = this.ioFileMgrBox.isSelected() ? loggers + "<logger name='hle.IoFileMgrForUser' />" + LB : loggers + "<logger name='hle.IoFileMgrForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.kernelLibBox.isSelected() ? loggers + "<logger name='hle.Kernel_Library' />" + LB : loggers + "<logger name='hle.Kernel_Library' > <level value='off' /> </logger>" + LB;
            loggers = this.loadCoreBox.isSelected() ? loggers + "<logger name='hle.LoadCoreForKernel' />" + LB : loggers + "<logger name='hle.LoadCoreForKernel' > <level value='off' /> </logger>" + LB;
            loggers = this.loadExecBox.isSelected() ? loggers + "<logger name='hle.LoadExecForUser' />" + LB : loggers + "<logger name='hle.LoadExecForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.moduleMgrBox.isSelected() ? loggers + "<logger name='hle.ModuleMgrForUser' />" + LB : loggers + "<logger name='hle.ModuleMgrForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.stdioBox.isSelected() ? loggers + "<logger name='hle.StdioForUser' />" + LB : loggers + "<logger name='hle.StdioForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.sysMemKernelBox.isSelected() ? loggers + "<logger name='hle.SysMemForKernel' />" + LB : loggers + "<logger name='hle.SysMemForKernel' > <level value='off' /> </logger>" + LB;
            loggers = this.sysMemUserBox.isSelected() ? loggers + "<logger name='hle.SysMemUserForUser' />" + LB : loggers + "<logger name='hle.SysMemUserForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.threadManBox.isSelected() ? loggers + "<logger name='hle.ThreadManForUser' />" + LB : loggers + "<logger name='hle.ThreadManForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.utilsBox.isSelected() ? loggers + "<logger name='hle.UtilsForUser' />" + LB : loggers + "<logger name='hle.UtilsForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.atracBox.isSelected() ? loggers + "<logger name='hle.sceAtrac3plus' />" + LB : loggers + "<logger name='hle.sceAtrac3plus' > <level value='off' /> </logger>" + LB;
            loggers = this.audioBox.isSelected() ? loggers + "<logger name='hle.sceAudio' />" + LB : loggers + "<logger name='hle.sceAudio' > <level value='off' /> </logger>" + LB;
            loggers = this.ctrlBox.isSelected() ? loggers + "<logger name='hle.sceCtrl' />" + LB : loggers + "<logger name='hle.sceCtrl' > <level value='off' /> </logger>" + LB;
            loggers = this.defltBox.isSelected() ? loggers + "<logger name='hle.sceDeflt' />" + LB : loggers + "<logger name='hle.sceDeflt' > <level value='off' /> </logger>" + LB;
            loggers = this.displayBox.isSelected() ? loggers + "<logger name='hle.sceDisplay' />" + LB : loggers + "<logger name='hle.sceDisplay' > <level value='off' /> </logger>" + LB;
            loggers = this.dmacBox.isSelected() ? loggers + "<logger name='hle.sceDmac' />" + LB : loggers + "<logger name='hle.sceDmac' > <level value='off' /> </logger>" + LB;
            loggers = this.fontBox.isSelected() ? loggers + "<logger name='hle.sceFont' />" + LB : loggers + "<logger name='hle.sceFont' > <level value='off' /> </logger>" + LB;
            loggers = this.geUserBox.isSelected() ? loggers + "<logger name='hle.sceGe_user' />" + LB : loggers + "<logger name='hle.sceGe_user' > <level value='off' /> </logger>" + LB;
            loggers = this.hprmBox.isSelected() ? loggers + "<logger name='hle.sceHprm' />" + LB : loggers + "<logger name='hle.sceHprm' > <level value='off' /> </logger>" + LB;
            loggers = this.imposeBox.isSelected() ? loggers + "<logger name='hle.sceImpose' />" + LB : loggers + "<logger name='hle.sceImpose' > <level value='off' /> </logger>" + LB;
            loggers = this.mp3Box.isSelected() ? loggers + "<logger name='hle.sceMp3' />" + LB : loggers + "<logger name='hle.sceMp3' > <level value='off' /> </logger>" + LB;
            loggers = this.mpegBox.isSelected() ? loggers + "<logger name='hle.sceMpeg' />" + LB : loggers + "<logger name='hle.sceMpeg' > <level value='off' /> </logger>" + LB;
            loggers = this.powerBox.isSelected() ? loggers + "<logger name='hle.scePower' />" + LB : loggers + "<logger name='hle.scePower' > <level value='off' /> </logger>" + LB;
            loggers = this.psmfBox.isSelected() ? loggers + "<logger name='hle.scePsmf' />" + LB : loggers + "<logger name='hle.scePsmf' > <level value='off' /> </logger>" + LB;
            loggers = this.psmfPlayerBox.isSelected() ? loggers + "<logger name='hle.scePsmfPlayer' />" + LB : loggers + "<logger name='hle.scePsmfPlayer' > <level value='off' /> </logger>" + LB;
            loggers = this.rtcBox.isSelected() ? loggers + "<logger name='hle.sceRtc' />" + LB : loggers + "<logger name='hle.sceRtc' > <level value='off' /> </logger>" + LB;
            loggers = this.sasBox.isSelected() ? loggers + "<logger name='hle.sceSasCore' />" + LB : loggers + "<logger name='hle.sceSasCore' > <level value='off' /> </logger>" + LB;
            loggers = this.suspendBox.isSelected() ? loggers + "<logger name='hle.sceSuspendForUser' />" + LB : loggers + "<logger name='hle.sceSuspendForUser' > <level value='off' /> </logger>" + LB;
            loggers = this.umdBox.isSelected() ? loggers + "<logger name='hle.sceUmdUser' />" + LB : loggers + "<logger name='hle.sceUmdUser' > <level value='off' /> </logger>" + LB;
            loggers = this.utilityBox.isSelected() ? loggers + "<logger name='hle.sceUtility' />" + LB : loggers + "<logger name='hle.sceUtility' > <level value='off' /> </logger>" + LB;
            loggers = this.cpuBox.isSelected() ? loggers + "<logger name='cpu' />" + LB : loggers + "<logger name='cpu' > <level value='off' /> </logger>" + LB;
            loggers = this.gpuBox.isSelected() ? loggers + "<logger name='ge' />" + LB : loggers + "<logger name='ge' > <level value='off' /> </logger>" + LB;
            loggers = this.compilerBox.isSelected() ? loggers + "<logger name='compiler' />" + LB : loggers + "<logger name='compiler' > <level value='off' /> </logger>" + LB;
            loggers = this.memBox.isSelected() ? loggers + "<logger name='memory' />" + LB : loggers + "<logger name='memory' > <level value='off' /> </logger>" + LB;
            loggers = this.emuBox.isSelected() ? loggers + "<logger name='emu' />" + LB : loggers + "<logger name='emu' > <level value='off' /> </logger>" + LB;
            loggers = this.loaderBox.isSelected() ? loggers + "<logger name='loader' />" + LB : loggers + "<logger name='loader' > <level value='off' /> </logger>" + LB;
            loggers = this.runtimeBox.isSelected() ? loggers + "<logger name='runtime' />" + LB : loggers + "<logger name='runtime' > <level value='off' /> </logger>" + LB;
            loggers = this.stdoutBox.isSelected() ? loggers + "<logger name='stdout' />" + LB : loggers + "<logger name='stdout' > <level value='off' /> </logger>" + LB;
            loggers = this.stderrBox.isSelected() ? loggers + "<logger name='stderr' />" + LB : loggers + "<logger name='stderr' > <level value='off' /> </logger>" + LB;
            loggers = loggers + "<!-- Output profiler info to 'profiler.txt' -->" + LB + "<logger name='profiler' additivity='false'>" + LB + "<level value='info' />" + LB + "<appender-ref ref='ProfilerTxtAppender' />" + LB + "</logger>" + LB;
        }
        return loggers;
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Settings.getInstance().writeBool("gui.openLogwindow", this.openLogWindowCheck.isSelected());
        Settings.getInstance().writeBool("gui.snapLogwindow", this.snapConsoleCheck.isSelected());
        if (!this.logKeywordField.getText().isEmpty()) {
            Settings.getInstance().writeString("log.keyword", this.logKeywordField.getText());
        } else {
            Settings.getInstance().writeString("log.keyword", "LOG_ALL");
        }
        if (this.snapConsoleCheck.isSelected() && this.mainWindow != null) {
            this.mainWindow.updateConsoleWinPosition();
        }
        this.dispose();
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("."));
        fc.setSelectedFile(new File(this.xmlpath.getText()));
        fc.addChoosableFileFilter(Constants.fltXMLFiles);
        fc.setFileFilter(Constants.fltXMLFiles);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            this.xmlpath.setText(fc.getSelectedFile().getPath());
            this.setLogSettingsFile();
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        try {
            File f = new File(this.LogSettingsPath);
            if (f.exists()) {
                f.delete();
            }
            String outName = "log";
            if (!this.logoutpath.getText().equals("")) {
                outName = this.logoutpath.getText();
            }
            RandomAccessFile raf = new RandomAccessFile(this.LogSettingsPath, "rw");
            String header = "<?xml version='1.0' encoding='UTF-8' ?>" + LB + "<!DOCTYPE log4j:configuration SYSTEM 'log4j.dtd'>" + LB + LB + "<log4j:configuration>" + LB + LB;
            String windowAppender = "<appender name='JpcspAppender' class='jpcsp.log.TextPaneAppender'>" + LB + "<layout class='org.apache.log4j.PatternLayout'>" + LB + "<param name='ConversionPattern' value='%r [%t] %-5p %c - %m%n' />" + LB + "</layout>" + LB + "</appender>" + LB;
            String htmlAppender = this.splitFilesBox.isSelected() ? "<appender name='HTMLAppender' class='org.apache.log4j.RollingFileAppender'>" + LB + "<param name='MaxFileSize' value='" + this.maxSizeSpinner.getValue() + "KB' />" + LB + "<param name='MaxBackupIndex' value='500' />" + LB + "<param name='File' value='" + outName + ".html' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='jpcsp.log.HTMLLayout'>" + LB + "<param name='Title' value='Jpcsp log file' />" + LB + "</layout>" + LB + "</appender>" + LB : "<appender name='HTMLAppender' class='org.apache.log4j.FileAppender'>" + LB + "<param name='File' value='" + outName + ".html' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='jpcsp.log.HTMLLayout'>" + LB + "<param name='Title' value='Jpcsp log file' />" + LB + "</layout>" + LB + "</appender>" + LB;
            String textAppender = this.splitFilesBox.isSelected() ? "<appender name='TxtAppender' class='org.apache.log4j.RollingFileAppender'>" + LB + "<param name='MaxFileSize' value='" + this.maxSizeSpinner.getValue() + "KB' />" + LB + "<param name='MaxBackupIndex' value='500' />" + LB + "<param name='File' value='" + outName + ".txt' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='org.apache.log4j.PatternLayout'>" + LB + "<param name='ConversionPattern' value='%5p %8c - %t - %m%n' />" + LB + "</layout>" + LB + "</appender>" + LB : "<appender name='TxtAppender' class='org.apache.log4j.FileAppender'>" + LB + "<param name='File' value='" + outName + ".txt' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='org.apache.log4j.PatternLayout'>" + LB + "<param name='ConversionPattern' value='%5p %8c - %t - %m%n' />" + LB + "</layout>" + LB + "</appender>" + LB;
            String profilerAppender = "<appender name='ProfilerTxtAppender' class='org.apache.log4j.FileAppender'>" + LB + "<param name='File' value='profiler.txt' />" + LB + "<param name='Append' value='false' />" + LB + "<layout class='org.apache.log4j.PatternLayout'>" + LB + "<param name='ConversionPattern' value='%m%n' />" + LB + "</layout>" + LB + "</appender>" + LB;
            String loggers = this.selectLoggers();
            String rootStart = LB + "<root>" + LB + "<level value ='off' />" + LB;
            String rootWindowAppender = "<appender-ref ref='JpcspAppender' />" + LB;
            String rootHtmlAppender = "<appender-ref ref='HTMLAppender' />" + LB;
            String rootTextAppender = "<appender-ref ref='TxtAppender' />" + LB;
            String rootEnd = "</root>" + LB + LB + "</log4j:configuration>" + LB;
            String contents = header + windowAppender;
            if (this.outputToHTML.isSelected()) {
                contents = contents + htmlAppender;
            }
            if (this.outputToText.isSelected()) {
                contents = contents + textAppender;
            }
            contents = contents + profilerAppender;
            contents = contents + loggers;
            contents = contents + rootStart;
            contents = contents + rootWindowAppender;
            if (this.outputToHTML.isSelected()) {
                contents = contents + rootHtmlAppender;
            }
            if (this.outputToText.isSelected()) {
                contents = contents + rootTextAppender;
            }
            contents = contents + rootEnd;
            raf.writeBytes(contents);
            raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.settingsArea.setText("");
        this.setLogSettingsFile();
    }

    private void splitFilesBoxActionPerformed(ActionEvent evt) {
        this.maxSizeSpinner.setEnabled(this.splitFilesBox.isSelected());
    }

    private void rbCustomActionPerformed(ActionEvent evt) {
        this.setCustom(true);
    }

    private void rbFullDebugActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void rbCoreDebugActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void rbGPUDebugActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void rbCPUDebugActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void rbGeneralDebugActionPerformed(ActionEvent evt) {
        this.setCustom(false);
    }

    private void logByKeywordCheckActionPerformed(ActionEvent evt) {
        if (this.logByKeywordCheck.isSelected()) {
            this.logKeywordField.setEditable(true);
        } else {
            this.logKeywordField.setText("LOG_ALL");
            this.logKeywordField.setEditable(false);
        }
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }
}

